
#include "poset.h"

// ***********************************************
// ***********************************************
// ***********************************************

std::shared_ptr<LinearPOSet> LinearPOSet::Build(std::shared_ptr<std::vector<std::string>> e) {
    //auto r = std::make_shared<LinearPOSet>();
    std::shared_ptr<LinearPOSet> r(new LinearPOSet());
    r->FillBaseAttribute(e, *(r->BuildComparability(e)), true);
    return r;
}

// ***********************************************
// ***********************************************
// ***********************************************

std::shared_ptr<std::list<std::pair<std::string, std::string>>>
LinearPOSet::BuildComparability(std::shared_ptr<std::vector<std::string>> e) {
    auto comparabilities = std::make_shared<std::list<std::pair<std::string, std::string>>>();
    for (std::uint_fast64_t k = 0; k < e->size() - 1; ++k) {
        comparabilities->push_back(std::make_pair(e->at(k), e->at(k + 1)));
    }
    return comparabilities;
}

// ***********************************************
// ***********************************************
// ***********************************************

std::shared_ptr<std::vector<std::vector<bool>>> LinearPOSet::IncidenceMatrix() const {
    auto result = std::make_shared<std::vector<std::vector<bool>>>(this->size(), std::vector<bool>(this->size(), false));
    
    for (std::uint64_t row = 0; row < elementi->size(); ++row) {
        for (std::uint64_t cols = row + 1; cols < elementi->size(); ++cols) {
            result->at(row).at(cols) =  true;
        }
    }
    
    return result;
     
}
