% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeatedCV_test.R
\name{repeatedCV_test}
\alias{repeatedCV_test}
\title{Repeated k-Fold Cross-Validation with Custom Test Metrics}
\usage{
repeatedCV_test(
  data,
  labels,
  k_folds = 5,
  repeats = 3,
  A = 1,
  test_type = "mccTest",
  seed = 1234
)
}
\arguments{
\item{data}{A data frame or matrix of features (predictor variables).}

\item{labels}{A vector of class labels corresponding to the rows of \code{data}.}

\item{k_folds}{An integer specifying the number of cross-validation folds (default = 5).}

\item{repeats}{An integer specifying the number of times the cross-validation is repeated (default = 3).}

\item{A}{number of score components}

\item{test_type}{A character string specifying the type of test to use. Options include:
\itemize{
  \item 'mccTest' for Matthews Correlation Coefficient (MCC),
  \item 'sensitivityTest' for Sensitivity,
  \item 'specificityTest' for Specificity,
  \item 'R2Test' for R-squared,
  \item 'scoreTest' for Score,
  \item 'F1Test' for F1 Score,
  \item 'FMTest' for Fowlkes-Mallows Index (FM),
  \item 'AUCTest' for Area Under the Curve (AUC),
  \item 'dQ2Test' for dQ2.
}
Default is 'mccTest'.}

\item{seed}{An integer for setting the random seed to ensure reproducibility (default = 1234).}
}
\value{
A numeric value representing the average performance metric across the outer folds.
}
\description{
This function performs repeated k-fold cross-validation and computes a selected performance metric across all repetitions and folds.
It allows for different types of performance tests, such as MCC, sensitivity, specificity, R2, F1, and more.
}
\examples{
datas <- simulatePilotData(nvar = 30, clus.size = c(15,15),m = 6,nvar_rel = 5,A = 1)
data <- datas$X
labels <- datas$Y
mean_mcc <- repeatedCV_test(data, labels, A = 1, test_type = 'mccTest')
cat('Mean MCC:', mean_mcc, '\n')

mean_score <- repeatedCV_test(data, labels, A = 1, test_type = 'scoreTest')
cat('Mean Sensitivity:', mean_score, '\n')

}
