% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{print.ppgam}
\alias{print.ppgam}
\title{Print a fitted \code{ppgam} object}
\usage{
\method{print}{ppgam}(x, ...)
}
\arguments{
\item{x}{a fitted \code{ppgam} object}

\item{...}{other arguments passed to \link[mgcv]{print.gam}}
}
\value{
Prints a details of a fitted ppgam object
}
\description{
Print a fitted \code{ppgam} object
}
\details{
Calls \link[mgcv]{print.gam}.
}
\examples{

# Times of landfalling US hurricanes
data(USlandfall)

# convert dates to years, as a continuous variable
year <- as.integer(format(USlandfall$date, "\%Y"))
day <- as.integer(format(USlandfall$date, "\%j"))
USlandfall$year <- year + pmin(day / 365, 1)
hits <- subset(USlandfall, landfall == 1)

# this creates nodes in the default way
m1 <- ppgam( ~ s(year), hits)
print(m1)

}
\seealso{
\link[mgcv]{print.gam}
}
