% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_zzz.R
\docType{class}
\name{TestDataB}
\alias{TestDataB}
\title{TestDataB}
\format{
An \code{R6} class object.
}
\description{
\code{R6} class of test data set for performance evaluation tools.
}
\details{
\code{TestDataB} is a class that contains scores and label for performance
  evaluation tools. It provides necessary methods for benchmarking.
}
\examples{
## Initialize with scores, labels, and a dataset name
testset <- TestDataB$new(c(0.1, 0.2, 0.3), c(0, 1, 1), "m1")
testset

}
\seealso{
\code{\link{create_testset}} for creating a list of test datasets.
  \code{\link{TestDataC}} is derived from this class for curve evaluation.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TestDataB-new}{\code{TestDataB$new()}}
\item \href{#method-TestDataB-get_tsname}{\code{TestDataB$get_tsname()}}
\item \href{#method-TestDataB-get_scores}{\code{TestDataB$get_scores()}}
\item \href{#method-TestDataB-get_labels}{\code{TestDataB$get_labels()}}
\item \href{#method-TestDataB-get_fg}{\code{TestDataB$get_fg()}}
\item \href{#method-TestDataB-get_bg}{\code{TestDataB$get_bg()}}
\item \href{#method-TestDataB-get_fname}{\code{TestDataB$get_fname()}}
\item \href{#method-TestDataB-del_file}{\code{TestDataB$del_file()}}
\item \href{#method-TestDataB-print}{\code{TestDataB$print()}}
\item \href{#method-TestDataB-clone}{\code{TestDataB$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-new"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-new}{}}}
\subsection{Method \code{new()}}{
Default class initialization method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$new(scores = NULL, labels = NULL, tsname = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scores}}{A vector of scores.}

\item{\code{labels}}{A vector of labels.}

\item{\code{tsname}}{A dataset name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-get_tsname"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-get_tsname}{}}}
\subsection{Method \code{get_tsname()}}{
Get the dataset name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$get_tsname()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-get_scores"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-get_scores}{}}}
\subsection{Method \code{get_scores()}}{
Get a vector of scores.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$get_scores()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-get_labels"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-get_labels}{}}}
\subsection{Method \code{get_labels()}}{
Get a vector of labels.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$get_labels()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-get_fg"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-get_fg}{}}}
\subsection{Method \code{get_fg()}}{
Get a vector of positive scores.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$get_fg()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-get_bg"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-get_bg}{}}}
\subsection{Method \code{get_bg()}}{
Get a vector of negative scores.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$get_bg()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-get_fname"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-get_fname}{}}}
\subsection{Method \code{get_fname()}}{
Get a file name that contains scores and labels.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$get_fname()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-del_file"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-del_file}{}}}
\subsection{Method \code{del_file()}}{
Delete the file with scores and labels.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$del_file()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-print"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-print}{}}}
\subsection{Method \code{print()}}{
Pretty print of the test dataset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TestDataB-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TestDataB-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TestDataB$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
