% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{prune_pre}
\alias{prune_pre}
\title{Get the optimal lambda and gamma parameter values for an ensemble of given size}
\usage{
prune_pre(object, nonzero, plusminus = 3)
}
\arguments{
\item{object}{an object of class \code{\link{pre}} that was fit using the relaxed lasso.
If an object of class \code{\link{pre}} is specified that was not fit using the relaxed lasso,
an error will be printed.}

\item{nonzero}{maximum number of terms to retain.}

\item{plusminus}{number of terms above and below \code{nonzero} for which CV results will be printed.}
}
\value{
The lambda and gamma values that yield optimal predictive accuracy for the specified
number of terms. These are invisibly returned, see Examples on how to use them. A sentence
describing what the optimal values are is printed to the command line, with an overview of
the performance (in terms of cross-validated accuracy and the number of terms retained) of 
lambda values near the optimum. If the specified number of terms to retain is lower than
what would be obtained using the \code{lambda.min} or \code{lambda.1se} criterion, a warning
will also be printed.
}
\description{
Function \code{prune_pre} returns the optimal values of lambda and gamma for
the requested ensemble size.
}
\examples{
\donttest{
## Fit a rule ensemble to predict Ozone concentration
airq <- airquality[complete.cases(airquality), ]
set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airq, relax = TRUE)

## Inspect the result (default lambda.1se criterion)
airq.ens

## Inspect the lambda path 
## (lower x-axis gives lambda values, upper x-axis corresponding no. of non-zero terms)
\dontrun{plot(airq.ens$glmnet.fit)}

## Accuracy still quite good with only 5 terms, obtain corresponding parameter values
opt_pars <- prune_pre(airq.ens, nonzero = 5)
opt_pars

## Use the parameter values for interpretation and prediction, e.g.
predict(airq.ens, newdat = airq[c(22, 33), ], penalty = opt_pars$lambda, gamma = opt_pars$gamma)
summary(airq.ens, penalty = opt_pars$lambda, gamma = opt_pars$gamma)
print(airq.ens, penalty = opt_pars$lambda, gamma = opt_pars$gamma)
}
}
\seealso{
\code{\link{pre}}
}
