% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precrec.R
\docType{package}
\name{precrec}
\alias{precrec-package}
\alias{precrec}
\title{precrec: A package for computing accurate ROC and Precision-Recall curves}
\description{
The precrec package contains several functions and \code{S3} generics to
provide a robust platform for performance evaluation of binary classifiers.
}
\section{Functions}{

The precrec package provides the following six functions.

  \tabular{ll}{
    \strong{Function} \tab \strong{Description} \cr
    \code{\link{evalmod}}
          \tab Main function to calculate evaluation measures \cr
    \code{\link{mmdata}}
          \tab Reformat input data for performance evaluation calculation \cr
    \code{\link{join_scores}}
          \tab Join scores of multiple models into a list \cr
    \code{\link{join_labels}}
          \tab Join observed labels of multiple test datasets into a list \cr
    \code{\link{create_sim_samples}}
          \tab Create random samples for simulations \cr
    \code{\link{format_nfold}}
          \tab Create n-fold cross validation dataset from data frame
  }
}

\section{S3 generics}{

The precrec package provides nine different \code{S3} generics for the
 \code{S3} objects generated by the \code{\link{evalmod}} function.

  \tabular{lll}{
    \strong{S3 generic}
    \tab \strong{Library}
    \tab \strong{Description} \cr
    \code{print}
    \tab base
    \tab Print the calculation results and the summary of the test data \cr
    \code{\link{as.data.frame}}
    \tab base
    \tab Convert a precrec object to a data frame \cr
    \code{\link{plot}}
    \tab graphics
    \tab Plot performance evaluation measures \cr
    \code{\link{autoplot}}
    \tab ggplot2
    \tab Plot performance evaluation measures with ggplot2  \cr
    \code{\link{fortify}}
    \tab ggplot2
    \tab Prepare a data frame for ggplot2 \cr
    \code{\link{auc}}
    \tab precrec
    \tab Make a data frame with AUC scores \cr
    \code{\link{part}}
    \tab precrec
    \tab Calculate partial curves and partial AUC scores \cr
    \code{\link{pauc}}
    \tab precrec
    \tab Make a data frame with pAUC scores \cr
    \code{\link{auc_ci}}
    \tab precrec
    \tab Calculate confidence intervals of AUC scores
  }
}

\section{Performance measure calculations}{

The \code{\link{evalmod}} function calculates ROC and Precision-Recall
  curves and returns an \code{S3} object. The generated \code{S3} object can
  be used with several different \code{S3} generics, such as \code{print} and
  \code{\link{plot}}. The \code{\link{evalmod}} function can also
  calculate basic evaluation measures - error rate, accuracy, specificity,
  sensitivity, precision, Matthews correlation coefficient, and F-Score.
}

\section{Data preparation}{

The \code{\link{mmdata}} function creates an input dataset for
 the \code{\link{evalmod}} function. The generated dataset contains
 formatted scores and labels.

\code{\link{join_scores}} and \code{\link{join_labels}} are helper
 functions to combine multiple scores and labels.

The \code{\link{create_sim_samples}} function creates test datasets with
 five different performance levels.
}

\section{Data visualization}{

\code{\link{plot}} takes an \code{S3} object generated
by \code{\link{evalmod}} as input and plot corresponding curves.

\code{\link{autoplot}} uses \code{ggplot} to plot curves.
}

\section{Result retrieval}{

\code{\link{as.data.frame}} takes an \code{S3} object generated
by \code{\link{evalmod}} as input and and returns a data frame
with calculated curve points.

\code{\link{auc}} and \code{\link{pauc}} returns a data frame with AUC scores
and partial AUC scores, respectively. \code{\link{auc_ci}}
returns confidence intervals of AUCs for both ROC
and precision-recall curves.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/evalclass/precrec}
  \item Report bugs at \url{https://github.com/evalclass/precrec/issues}
}

}
\author{
\strong{Maintainer}: Takaya Saito \email{takaya.saito@outlook.com} (\href{https://orcid.org/0000-0002-0154-8452}{ORCID})

Authors:
\itemize{
  \item Marc Rehmsmeier \email{marc.rehmsmeier@ii.uib.no} (\href{https://orcid.org/0000-0002-5021-7721}{ORCID})
}

}
