% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{get_sequence}
\alias{get_sequence}
\title{Retrieves a fasta sequence from NCBI nucleotide database.}
\usage{
get_sequence(
  accession,
  start = NULL,
  stop = NULL,
  api_key = Sys.getenv("NCBI_API_KEY")
)
}
\arguments{
\item{accession}{nucleotide accession to retrieve.}

\item{start}{start base to retrieve, numbered beginning at 1.  If NULL the
beginning of the sequence.}

\item{stop}{last base to retrieve, numbered beginning at 1. if NULL the end of
the sequence.}

\item{api_key}{NCBI api-key to allow faster sequence retrieval.}
}
\value{
an DNAbin object.
}
\description{
Retrieves a fasta sequence from NCBI nucleotide database.
}
\seealso{
\code{\link[ape]{DNAbin}}
}
