% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_df.R
\name{tibble-methods}
\alias{tibble-methods}
\alias{nrow,tbl_df-method}
\alias{ncol,tbl_df-method}
\alias{as.list,tbl_df-method}
\title{Manipulate tibbles}
\usage{
\S4method{nrow}{tbl_df}(x)

\S4method{ncol}{tbl_df}(x)

\S4method{as.list}{tbl_df}(x)
}
\arguments{
\item{x}{\code{\link[tibble:tibble]{tibble::tibble()}} object.}
}
\description{
Assorted functions for manipulating \code{\link[tibble:tibble]{tibble::tibble()}} objects.
}
\details{
The following methods are provided from manipulating
\code{\link[tibble:tibble]{tibble::tibble()}} objects.

\describe{
\item{nrow}{\code{integer} number of rows.}

\item{ncol}{\code{integer} number of columns.}

\item{as.list}{convert to a \code{list}.}

\item{print}{print the object.}

}
}
\examples{
# load tibble package
require(tibble)

# make tibble
a <- tibble(value = seq_len(5))

# number of rows
nrow(a)

# number of columns
ncol(a)

# convert to list
as.list(a)
}
