% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_anova.R
\name{print_anova}
\alias{print_anova}
\title{Print the results of an \code{afex} ANOVA}
\usage{
print_anova(afex_object, italic_eta = TRUE, decimals = 2, decimals_p = 3)
}
\arguments{
\item{afex_object}{An object returned by one of \code{afex}'s ANOVA
functions. See details.}

\item{italic_eta}{Should the effect size symbol eta be printed in
italic font. Defaults to \code{TRUE}. See details.}

\item{decimals}{How many decimals should be printed for F values
and eta-squared. Defaults to 2.}

\item{decimals_p}{How many decimals should be printed for p-values.
Defaults to 3.}
}
\value{
A list whose elements are strings describing the effects of the ANOVA (main effects and interactions);
to be included in an R markdown document.
}
\description{
Print the results of an \code{afex} ANOVA
}
\details{
To use this function, you have to install the package afex to compute
an ANOVA object, see \code{\link[afex]{aov_car}}. Pass this object
as the first argument.

According to APA style, the Greek eta symbol - indicating the
effect size in  the ANOVA - should be printed in non-italic font.
However, the standard \\eta symbol is written in italic. To print a
non-italic eta, use the argument \code{italic_eta = FALSE}. However,
this option requires that you load the Latex package \code{upgreek} in
the YAML header of your R markdown document. To this end, use the following
option in your YAML header:

\if{html}{\out{<div class="sourceCode">}}\preformatted{header-includes:
  -\\usepackage\{upgreek\}
}\if{html}{\out{</div>}}

This option only works for Latex/PDF output.
}
\examples{

library("afex")
# see ?aov_ez
data(md_12.1)
aov_results <- aov_ez("id", "rt", md_12.1, within = c("angle", "noise"))
print_anova(aov_results)

# Print nonitalic eta, which is required according to APA guidelines
print_anova(aov_results, italic_eta = FALSE)

# Example using other (or no) effect size index
pes <- aov_ez("id", "rt", md_12.1, within = c("angle", "noise"),
              anova_table = list(es = "pes"))
print_anova(pes)
print_anova(pes, italic_eta = FALSE)
noes <- aov_ez("id", "rt", md_12.1, within = c("angle", "noise"),
               anova_table = list(es = "none"))
print_anova(noes)

## Access individual elements of the ANOVA print list:
aovpr <- print_anova(aov_results, italic_eta = FALSE)
# By index: 
aovpr[[1]]
# By name (main effect): 
aovpr$angle
aovpr[["angle"]]
# By name (interaction effect, here, the $-notation does not work 
# due to non-standard `:` in name): 
aovpr[["angle:noise"]] 


}
\references{
Singmann, H., Bolker, B., Westfall, J., & Aust, F. (2019). afex:
Analysis of Factorial Experiments. https://CRAN.R-project.org/package=afex
}
\author{
Martin Papenberg \email{martin.papenberg@hhu.de}
}
