% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-estimate-none.R
\name{cal_estimate_none}
\alias{cal_estimate_none}
\alias{cal_estimate_none.data.frame}
\alias{cal_estimate_none.tune_results}
\alias{cal_estimate_none.grouped_df}
\title{Do not calibrate model predictions.}
\usage{
cal_estimate_none(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  parameters = NULL,
  ...
)

\method{cal_estimate_none}{data.frame}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  parameters = NULL,
  ...,
  .by = NULL
)

\method{cal_estimate_none}{tune_results}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred"),
  parameters = NULL,
  ...
)

\method{cal_estimate_none}{grouped_df}(.data, truth = NULL, estimate = NULL, parameters = NULL, ...)
}
\arguments{
\item{.data}{An ungrouped \code{data.frame} object, or \code{tune_results} object,
that contains predictions and probability columns.}

\item{truth}{The column identifier for the true outcome results
(that is factor or numeric). This should be an unquoted column name.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities or
numeric predictions. It defaults to the prefix used by tidymodels (\code{.pred_}).
For classification problems, the order of the identifiers will be considered
the same as the order of the levels of the \code{truth} variable.}

\item{parameters}{(Optional)  An optional tibble of tuning parameter values
that can be used to filter the predicted values before processing. Applies
only to \code{tune_results} objects.}

\item{...}{Additional arguments passed to the models or routines used to
calculate the new probabilities.}

\item{.by}{The column identifier for the grouping variable. This should be
a single unquoted column name that selects a qualitative variable for
grouping. Default to \code{NULL}. When \code{.by = NULL} no grouping will take place.}
}
\description{
Do not calibrate model predictions.
}
\details{
This function does nothing to the predictions. It is used as a
reference when tuning over different calibration methods.
}
\examples{

nada <- cal_estimate_none(boosting_predictions_oob, outcome, .pred)
nada

identical(
  cal_apply(boosting_predictions_oob, nada),
  boosting_predictions_oob
)

# ------------------------------------------------------------------------------

nichts <- cal_estimate_none(segment_logistic, Class)

identical(
  cal_apply(segment_logistic, nichts),
  segment_logistic
)
}
