% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_projoint_choice_level_mm.R
\name{plot_projoint_choice_level_mm}
\alias{plot_projoint_choice_level_mm}
\title{Plot choice-level marginal means (MMs) (helper)}
\usage{
plot_projoint_choice_level_mm(
  x,
  .type = "pointrange",
  .estimates = "corrected",
  .labels = NULL,
  .show_attribute = TRUE,
  .remove_xaxis = FALSE,
  .xlim = c(0, 1),
  .plot.margin = c(top = 1, left = 2, bottom = 1, right = 2),
  ...
)
}
\arguments{
\item{x}{A \code{\link{projoint_results}} object produced by
\code{\link{projoint}} with \code{structure = "choice_level"} and
\code{estimand = "mm"}.}

\item{.type}{Character. Either \code{"bar"} (two bars with CIs) or
\code{"pointrange"} (horizontal estimate with CI and level labels at the
extremes). Default \code{"pointrange"}.}

\item{.estimates}{Character. Which estimate version to plot:
\code{"corrected"} (default) or \code{"uncorrected"}.}

\item{.labels}{Optional character vector of length 2 for custom level labels
(left/right). If \code{NULL}, labels are derived from \code{x$labels}.}

\item{.show_attribute}{Logical; if \code{TRUE} (default), add the attribute
name as the title when both levels are from the same attribute.}

\item{.remove_xaxis}{Logical; if \code{TRUE}, remove x-axis line, ticks, and
labels (useful when embedding). Default \code{FALSE}.}

\item{.xlim}{Numeric length-2 giving the x-axis limits. Default \code{c(0, 1)}.}

\item{.plot.margin}{Numeric vector of plot margins in cm,
\code{c(top, left, bottom, right)}. Default \code{c(1, 2, 1, 2)}.}

\item{...}{Currently unused (reserved for future extensions).}
}
\value{
A \code{ggplot2} object.
}
\description{
Internal helper used by \code{\link{plot.projoint_results}} to render
choice-level marginal means (MMs). Supports a bar chart or a horizontal
pointrange layout and optional custom level labels.
}
\details{
This helper expects that the \code{projoint_results} object \emph{already}
contains a single pair of choice-level MMs (i.e., one \code{att_level_choose}
and one \code{att_level_notchoose}). It is called internally by
\code{\link{plot.projoint_results}} when \code{x$structure == "choice_level"}
and \code{x$estimand == "mm"}.

When \code{.type = "pointrange"}, the level labels are placed just outside
\code{.xlim} to avoid overlap with the confidence interval. If the two levels
correspond to different attributes, the attribute title is omitted and a
message is emitted.
}
\examples{
data(exampleData1)
dat <- reshape_projoint(exampleData1,
  .outcomes = c("choice1", "choice2", "choice1_repeated_flipped")
)
att <- unique(dat$labels$attribute_id)[1]
levs <- subset(dat$labels, attribute_id == att)$level_id
lev_names <- sub(".*:", "", levs)
q <- set_qoi("choice_level", "mm",
  .att_choose = att, .lev_choose = lev_names[2],
  .att_notchoose = att, .lev_notchoose = lev_names[1]
)
fit <- projoint(dat, .qoi = q)
plot(fit)
}
\seealso{
\code{\link{plot.projoint_results}} for the user-facing plot method.
}
\keyword{internal}
