/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util;

import com.qarks.util.PreferenceManager;
import com.qarks.util.stream.FileHelper;
import com.qarks.util.xml.XMLBeanUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PreferenceManagerImpl
implements PreferenceManager {
    private static PreferenceManagerImpl instance = null;
    private Properties props = null;
    private int currentIndex = 1;
    private File indexFile;
    private File storageDir;

    private PreferenceManagerImpl() {
        String string = System.getProperty("user.home") + File.separator + ".pref";
        String string2 = System.getProperty("spamworks.util.prefencence.folder", string);
        this.storageDir = new File(string2);
        if (!this.storageDir.exists()) {
            this.storageDir.mkdirs();
        }
        this.indexFile = new File(this.storageDir, "index_2.txt");
        if (this.indexFile.exists()) {
            this.currentIndex = 2;
        } else {
            this.indexFile = new File(this.storageDir, "index_1.txt");
            try {
                this.indexFile.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        File file = new File(this.storageDir, "datas_" + this.currentIndex + ".xml");
        if (file.exists()) {
            try {
                this.props = (Properties)this.restore(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.props == null) {
            this.props = new Properties();
        }
    }

    public static synchronized PreferenceManagerImpl getInstance() {
        if (instance == null) {
            instance = new PreferenceManagerImpl();
        }
        return instance;
    }

    @Override
    public synchronized void flush() {
        try {
            this.currentIndex = this.currentIndex == 1 ? 2 : 1;
            File file = new File(this.storageDir, "datas_" + this.currentIndex + ".xml");
            this.store(this.props, file);
            File file2 = new File(this.storageDir, "index_" + this.currentIndex + ".txt");
            if (this.indexFile.renameTo(file2)) {
                this.indexFile = file2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getProperty(String string, String string2) {
        return this.props.getProperty(string, string2);
    }

    @Override
    public void removeProperty(String string) {
        this.props.remove(string);
    }

    @Override
    public void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(Object object, File file) throws IOException {
        byte[] byArray = XMLBeanUtilities.objectToBytes(object);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private Object restore(File file) throws IOException {
        Object object = null;
        if (file.exists()) {
            String string = FileHelper.getFileContent(file);
            object = XMLBeanUtilities.bytesToObject(string.getBytes());
        }
        return object;
    }
}

