% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot_alphabeta.R
\name{.gamma}
\alias{.gamma}
\title{Calculate Gamma of Irreplaceability}
\usage{
.gamma(alphas, na.rm = FALSE)
}
\arguments{
\item{alphas}{vector - A vector of numbers between 0-1.}

\item{na.rm}{logical - Should missing values (NA) be removed?}
}
\value{
A non-negative number.
}
\description{
This function calculates Gamma of Irreplaceability from a vector of Alpha
Irreplaceability values. Alpha Irreplaceability values can be calculated using
\code{\link{.alpha}()}.
}
\details{
Gamma of Irreplaceability is not a true irreplaceability metric, but allows
for ranking between sites better than Beta. It is a non-negative number where
the integer component represents the number of species for whom the site is
wholly irreplaceable (Alpha=1) plus a decimal component calculated as a Beta
calculated on all species for whom the site is not irreplaceable (Alpha<1).
}
\examples{
.gamma(alphas=c(0.1,0.32,0.5))
.gamma(alphas=c(0.1,0.32,0.9))
.gamma(alphas=c(0.1,0.32,1))
.gamma(alphas=c(0.1,0.32,1,1))
.gamma(alphas=c(0.1,0.32,NA), na.rm=TRUE)
}
\references{
\doi{10.1111/cobi.13806}
}
\author{
Daniele Baisero, \email{daniele.baisero@gmail.com}
}
\keyword{internal}
