% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.psbcSpeedUp.R
\name{predict.psbcSpeedUp}
\alias{predict.psbcSpeedUp}
\title{Predict survival risk}
\usage{
\method{predict}{psbcSpeedUp}(
  object,
  survObj.new = NULL,
  type = "brier",
  method = "mean",
  times = NULL,
  ...
)
}
\arguments{
\item{object}{fitted object obtained with \code{psbcSpeedUp}}

\item{survObj.new}{a list containing observed data from new subjects with
components \code{t}, \code{di}, \code{x}. If \code{NULL}, the prediction is
based on the training data. If \code{type} is among
\code{c("hazard", "cumhazard", "survival")}, only \code{survObj.new$x} is needed}

\item{type}{option to chose for predicting survival probabilities (one of
\code{c('hazard','cumhazard','survival')}) or brier scores (\code{type="brier"})}

\item{method}{option to use the posterior mean (\code{"mean"}) of coefficients
for prediction or Bayesian model averaging (\code{"BMA"}) for prediction}

\item{times}{time points at which to evaluate the risks. If \code{NULL}
(default), the event/censoring times are used. If \code{type="brier"}, the
largest one of the \code{times} is used}

\item{\dots}{not used}
}
\description{
Predict survival probability, (cumulative) hazard or (integrated) Brier scores based on Cox regression models
}
\details{
psbcSpeedUp
}
\examples{

# Load the example dataset
data("exampleData", package = "psbcSpeedUp")
p <- exampleData$p
q <- exampleData$q
survObj <- exampleData[1:3]

# Set hyperparameters
mypriorPara <- list(
  "groupInd" = 1:p, "eta0" = 0.02, "kappa0" = 1, "c0" = 2, "r" = 10 / 9,
  "delta" = 1e-05, "lambdaSq" = 1, "sigmaSq" = runif(1, 0.1, 10),
  "beta.prop.var" = 1, "beta.clin.var" = 1)

\donttest{
# run Bayesian Lasso Cox
library("psbcSpeedUp")
library("survival")
set.seed(123)
fitBayesCox <- psbcSpeedUp(survObj,
  p = p, q = q, hyperpar = mypriorPara,
  nIter = 10, burnin = 0, outFilePath = tempdir()
)
# predict survival probabilities of the train data
predict(fitBayesCox)
}

}
\keyword{survival}
