% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{plot.pCure}
\alias{plot.pCure}
\title{Plot method for 'pCure' objects}
\usage{
\method{plot}{pCure}(x, part = "both", type = c("residuals", "cv", "trace"), ...)
}
\arguments{
\item{x}{An object of class 'pCure', usually returned by the 'pCure()' function.}

\item{part}{A character string specifies which component of the cure model to plot.
The default is "both", which plots both the incidence and latency components if a
mixture cure model was fitted,
or both the long- and short-term effects if a promotion time model was fitted.}

\item{type}{A character string specifying the type of plot to generate.
Available options are "residuals," "cv," and "trace,"
which correspond to the pseudo-residual plot, cross-validation plot,
and trace plot for different values of the tuning parameter, respectively.}

\item{...}{Other arguments for future extension.}
}
\value{
A ggplot object representing the residual plot, cross-validation plot,
or the trace plot for an object of class \code{"pCure"}. 
This can be further modified using \code{"ggplot2"} functions.
}
\description{
Plot method for 'pCure' objects
}
