% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptvalue.R
\name{invert_sign}
\alias{invert_sign}
\alias{abs_sign}
\alias{as_times}
\alias{as_div}
\title{Basic functions for converting ptvalues}
\usage{
invert_sign(x = double())

abs_sign(x = double(), sign = "times")

as_times(x = double())

as_div(x = double())
}
\arguments{
\item{x}{A vector of class \strong{ptvalue} or a numeric vector. If a numeric
vector is provided, values must be greater than 0.}

\item{sign}{Either \code{"times"} or \code{"div"}. Default to \code{"times"}.}
}
\value{
A vector of class \code{ptvalue}.
}
\description{
\itemize{
\item \code{invert_sign()} inverts ptvalues' sign.
\item \code{abs_sign()} converts ptvalues' sign to an 'absolute' sign, times or div.
\item \code{as_times()} converts ptvalues' sign to all times.
\item \code{as_div()} converts ptvalues' sign to all div.
}
}
\details{
The function \code{invert_sign()} is the same as applying \eqn{ \frac{1}{x} } with
the underlying numeric values of ptvalues. Times values (\eqn{\times}) will
be converted to div (\eqn{\div}) and div to times.

The function \code{abs_sign()} finds the multiplicative absolute values where all
times and div values are converted to times values (by default). It can also
converts to all div values by specifying \code{sign = "div"}.

Functions \code{as_times()} and \code{as_div()} are wrappers of \code{abs_sign()} where
\code{sign = "times"} is specified for \code{as_times()} and \code{sign = "div"} is
specified for \code{as_div()}.

All functions will return a vector of class \strong{ptvalue} even when providing
a numeric vector for \code{x} as it is the expected use. To see the underlying
numeric vector, you can use \code{unclass()} or \code{as.double()}.
}
\examples{
x <- ptvalue(c(0.25, 0.5, 1, 2, 4))
x

abs_sign(x)
invert_sign(x)
as_times(x)
as_div(x)
}
