% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varx.R
\name{VECM}
\alias{VECM}
\title{Estimation of a Vector Error Correction Model}
\usage{
VECM(
  y,
  dim_p,
  x = NULL,
  dim_q = dim_p,
  dim_r = NULL,
  beta = NULL,
  type = c("Case1", "Case2", "Case3", "Case4", "Case5"),
  t_D1 = list(),
  t_D2 = list(),
  D1 = NULL,
  D2 = NULL
)
}
\arguments{
\item{y}{Matrix. A \eqn{(K \times (p+T))} data matrix of the \eqn{K} endogenous time series variables.}

\item{dim_p}{Integer. Lag-order \eqn{p} for the endogenous variables \code{y}.}

\item{x}{Matrix. A \eqn{(L \times (p+T))} data matrix of the \eqn{L} weakly exogenous time series variables.}

\item{dim_q}{Integer. Lag-order \eqn{q} for the distributed lag of the weakly exogenous variables \code{x}.}

\item{dim_r}{Integer. Cointegration-rank \eqn{r} of the VECM.}

\item{beta}{Matrix. A \eqn{((K+L+n_{d1}) \times r)} cointegrating matrix to be imposed -- 
or estimated by the reduced-rank regression if \code{NULL} (the default).}

\item{type}{Character. The conventional case of the 
\link[=as.t_D]{deterministic term} in the Johansen procedure.}

\item{t_D1}{List of vectors. The activating break periods \eqn{\tau} 
for the period-specific \link[=as.t_D]{deterministic regressors} in \eqn{d_{1,t}}, 
which are restricted to the cointegration relations.
Just as in \code{\link{coint}}, the 
accompanying lagged regressors are automatically included in \eqn{d_{2,t}}.}

\item{t_D2}{List of vectors. The activating break periods \eqn{\tau} 
for the period-specific \link[=as.t_D]{deterministic regressors} in \eqn{d_{2,t}}, 
which are unrestricted.}

\item{D1}{Matrix. A \eqn{(n_{\bullet} \times (p+T))} data matrix of customized 
\link[=as.t_D]{deterministic regressors} added to \eqn{d_{1,t}}, 
which are restricted to the cointegration relations. 
Unlike '\code{t_D1}', these customized regressors require potential
accompanying regressors to be manually included in \eqn{d_{2,it}}.}

\item{D2}{Matrix. A \eqn{(n_{\bullet} \times (p+T))} data matrix of customized 
\link[=as.t_D]{deterministic regressors} added to \eqn{d_{2,t}}, 
which are unrestricted. 
These additional regressors correspond to '\code{dumvar}' in \strong{urca}'s 
\code{\link[urca]{ca.jo}}, which is fixed over bootstrap iterations.}
}
\value{
A list of class '\code{\link[=as.varx]{varx}}'.
}
\description{
Estimates a VECM under a given cointegration-rank restriction or cointegrating vectors.
}
\examples{
### extend basic example in "vars" ###
library(vars)
data(Canada)
names_k = c("e", "U", "rw")  # names of endogenous variables
names_l = c("prod")  # names of exogenous variables
names_s = NULL  # optional shock names
x = Canada[ , names_l, drop=FALSE]
y = Canada[ , names_k, drop=FALSE]

# colnames of the restriction matrices are passed as shock names #
SR = matrix(NA, nrow=4, ncol=4, dimnames=list(NULL, names_s))
SR[4, 2] = 0
LR = matrix(NA, nrow=4, ncol=4, dimnames=list(NULL, names_s))
LR[1, 2:4] = 0
LR[2:4, 4] = 0

# estimate, identify, and plot the IRF #
R.vecm = VECM(y=y, dim_p=3, x=x, dim_q=3, dim_r=1, type="Case4")
R.grt  = id.grt(R.vecm, LR=LR, SR=SR)
R.irf  = irf(R.grt, n.ahead=50)
plot(R.irf)

}
\references{
Johansen, S. (1996): 
  \emph{Likelihood-Based Inference in Cointegrated Vector Autoregressive Models}, 
  Advanced Texts in Econometrics, Oxford University Press, USA.

Luetkepohl, H. (2005): 
  \emph{New Introduction to Multiple Time Series Analysis}, 
  Springer, 2nd ed.
}
