% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_precision.R
\name{md_prec}
\alias{md_prec}
\title{Compute Precision Analyses for Mean Differences}
\usage{
md_prec(m1, m2, s1, s2, nlow, nhigh, propn1 = 0.5, ci = 0.95, by = 1)
}
\arguments{
\item{m1}{Mean of first group}

\item{m2}{Mean of second group}

\item{s1}{Standard deviation of first group}

\item{s2}{Standard deviation of second group}

\item{nlow}{starting sample size}

\item{nhigh}{ending sample size}

\item{propn1}{Proportion in First Group}

\item{ci}{Type of Confidence Interval (e.g., .95)}

\item{by}{Incremental increase in sample (e.g. nlow = 10, nhigh = 24, by = 2, produces estimates of 10, 12, and 14)}
}
\value{
Precision Analyses for Mean Differences
}
\description{
Compute Precision Analyses for Mean Differences
}
\examples{
md_prec(m1=2,m2 =0, s1=5, s2=5,nlow=100, nhigh =1600, propn1=.5, ci=.95, by=100)
md_prec(m1=0,m2 =0, s1=5, s2=5,nlow=100, nhigh =40000, propn1=.5, ci=.95, by=1000)
}
