% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R, R/summary_methods.R
\name{summary.qbrms_fit}
\alias{summary.qbrms_fit}
\title{Summary Method for qbrms_fit Objects}
\usage{
\method{summary}{qbrms_fit}(object, ..., digits = 2)

\method{summary}{qbrms_fit}(object, ..., digits = 2)
}
\arguments{
\item{object}{A qbrms_fit object}

\item{...}{Additional arguments}

\item{digits}{Number of digits for output (default 2)}
}
\value{
An object of class \code{"summary.qbrms_fit"} containing:
\itemize{
\item \code{formula}: The model formula.
\item \code{family}: The distribution family.
\item \code{nobs}: Number of observations.
\item \code{fixed}: Data frame of fixed effects estimates.
\item \code{random}: Random effects summary (if applicable).
}
}
\description{
Provides a detailed summary of a fitted qbrms model.
}
\examples{
\donttest{
if (requireNamespace("INLA", quietly = TRUE)) {
  fit <- qbrms(mpg ~ hp, data = mtcars, family = gaussian(), verbose = FALSE)
  summary(fit)
}
}

}
