% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcapower.R
\name{qp_cases}
\alias{qp_cases}
\title{Calculte the number of cases for a particular case target based on simulated
data}
\usage{
qp_cases(power_target, null_hypo, alt_hypo)
}
\arguments{
\item{power_target}{Desired level of power}

\item{null_hypo}{Null hypothesis (\emph{H0}). Consistency value separating
consistent from inconsistent terms.}

\item{alt_hypo}{Alternative hypothesis (\emph{H1}). Expected, actual
consistency value of term.}
}
\value{
An integer showing how many cases are needed to achieve the
target level of power.
}
\description{
\code{qp_cases} calculates the number of cases needed for a particular
power level. It is based on the presimulated data using \code{qcapower}.
See the vignette for more details.
}
\examples{
qp_cases(0.1, null_hypo = 0.8, alt_hypo = 1)

}
\seealso{
\code{\link{qp_cases_brute}}
}
