% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetHinfo.R
\name{GetH1AtLeast}
\alias{GetH1AtLeast}
\title{Specify the configurations corresponding to the composite \eqn{H_1} test "AtLeast".}
\usage{
GetH1AtLeast(Hconfig, AtLeast, Consecutive = FALSE, SameSign = FALSE)
}
\arguments{
\item{Hconfig}{A list of all possible combination of \eqn{H_0} and \eqn{H_1} hypotheses generated by the \code{\link[=GetHconfig]{GetHconfig()}} function.}

\item{AtLeast}{How many \eqn{H_1} hypotheses at least for the item to be of interest ? (an integer or a vector).}

\item{Consecutive}{Should the significant test series be consecutive ? (optional, default is \code{FALSE}).}

\item{SameSign}{Should the significant test series have the same sign ? (optional, default is \code{FALSE}).}
}
\value{
A vector '\code{Hconfig.H1}' of components of \code{Hconfig} that correspond to the '\code{AtLeast}' specification.
}
\description{
Specify which configurations among \code{Hconfig} correspond
to the composite alternative hypothesis : \{at least "\code{AtLeast}" \eqn{H_1} hypotheses are of interest \}
}
\examples{
GetH1AtLeast(GetHconfig(4), 2)

}
\seealso{
\code{\link[=GetH1Equal]{GetH1Equal()}}
}
