% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastKerFDR_functions.R
\name{f1_separation_signed}
\alias{f1_separation_signed}
\title{Signed case function: Separate f1 into f+ and f-}
\usage{
f1_separation_signed(XMat, f0Mat, f1Mat, p0, plotting = FALSE)
}
\arguments{
\item{XMat}{a matrix of probit-transformed p-values, each column corresponding to a p-value serie.}

\item{f0Mat}{a matrix containing the evaluation of the marginal density functions under \eqn{H_0} at each items,
each column corresponding to a p-value serie.}

\item{f1Mat}{a matrix containing the evaluation of the marginal density functions under \eqn{H_1} at each items,
each column corresponding to a p-value serie.}

\item{p0}{the proportions of \eqn{H_0} items for each series.}

\item{plotting}{boolean, should some diagnostic graphs be plotted. (Default is FALSE.)}
}
\value{
A list with the following elements:
\tabular{ll}{
\code{f1plusMat} \tab a matrix containing the evaluation of the marginal density functions under \eqn{H_1^+}
at each items, each column corresponding to a p-value serie. \cr
\code{f1minusMat} \tab a matrix containing the evaluation of the marginal density functions under \eqn{H_1^-}
at each items, each column corresponding to a p-value serie. \cr
\code{p1plus} \tab an estimate of the proportions of \eqn{H_1^+} items for each series. \cr
\code{p1minus} \tab an estimate of the proportions of \eqn{H_1^-} items for each series.
}
}
\description{
Signed case function: Separate f1 into f+ and f-
}
