% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qch_fit.R
\name{qch.fit}
\alias{qch.fit}
\title{Infer posterior probabilities of \eqn{H_0}/\eqn{H_1} configurations.}
\usage{
qch.fit(
  pValMat,
  EffectMat = NULL,
  Hconfig,
  copula = "indep",
  threads_nb = 0,
  plotting = FALSE,
  Precision = 1e-06
)
}
\arguments{
\item{pValMat}{A matrix of p-values, each column corresponding to a p-value serie.}

\item{EffectMat}{A matrix of estimated effects corresponding to the p-values contained in \code{pValMat}.
If specified, the procedure will account for the direction of the effect. (optional, default is \code{NULL})}

\item{Hconfig}{A list of all possible combination of \eqn{H_0} and \eqn{H_1} hypotheses generated by the \code{\link[=GetHconfig]{GetHconfig()}} function.}

\item{copula}{A string specifying the form of copula to use. Possible values are "\code{indep}"and "\code{gaussian}".
Default is "\code{indep}" corresponding to the independent case.}

\item{threads_nb}{The number of threads to use. The number of thread will set to the number of cores available by default.}

\item{plotting}{A boolean. Should some diagnostic graphs be plotted ? Default is \code{FALSE}.}

\item{Precision}{The precision for EM algorithm to infer the parameters. Default is \code{1e-6}.}
}
\value{
A list with the following elements:
\tabular{ll}{
\code{prior} \tab vector of estimated prior probabilities
for each of the H-configurations.\cr
\code{Rcopula} \tab the estimated correlation matrix of the Gaussian copula.
(if applicable)\cr
\code{Hconfig} \tab the list of all configurations.\cr
\code{null_prop} \tab the estimation of items under the null for each test series.
}

\itemize{
\item If the storage permits, the list will additionally contain:
\tabular{ll}{
\code{posterior} \tab matrix providing for each item (in row) its posterior probability to
belong to each of the H-configurations (in columns).\cr
\code{fHconfig} \tab matrix containing \eqn{\psi_c} densities evaluated at each items,
each column corresponding to a configuration.
}

\item Else, the list will additionally contain:
\tabular{ll}{
\code{f0Mat} \tab matrix containing the evaluation of the marginal densities under \eqn{H_0} at each items,
each column corresponding to a p-value serie.\cr
\code{f1Mat} \tab matrix containing the evaluation of the marginal densities under \eqn{H_1} at each items,
each column corresponding to a p-value serie.\cr
\code{F0Mat} \tab matrix containing the evaluation of the marginal cdf under \eqn{H_0} at each items,
each column corresponding to a p-value serie.\cr
\code{F1Mat} \tab matrix containing the evaluation of the marginal cdf under \eqn{H_1} at each items,
each column corresponding to a p-value serie.\cr
\code{fHconfig_sum} \tab vector containing \eqn{(\sum_cw_c\psi_c(Z_i))} for each items \eqn{i}.\cr
}
}

The elements of interest are the posterior probabilities matrix, \code{posterior},
the estimated proportion of observations belonging to each configuration, \code{prior}, and
the estimated correlation matrix of the Gaussian copula, \code{Rcopula}.
The remaining elements are returned primarily for use by other functions.
}
\description{
For each item, estimate the posterior probability for each configuration.
This function use either the model accounting for the dependence structure
through a Gaussian copula function (\code{copula=="gaussian"}) or
assuming the conditional independence (\code{copula=="indep"}).
Utilizes parallel computing, when available. For package documentation, see \code{\link{qch-package}}.
}
\examples{
data(PvalSets_cor)
PvalMat <- as.matrix(PvalSets_cor[, -3])
## Build the Hconfig objects
Q <- 2
Hconfig <- GetHconfig(Q)

## Run the function
res.fit <- qch.fit(pValMat = PvalMat, Hconfig = Hconfig, copula = "gaussian")

## Display the prior of each class of items
res.fit$prior

## Display the correlation estimate of the gaussian copula
res.fit$Rcopula

## Display the first posteriors
head(res.fit$posterior)
}
