% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_ghost.R
\name{make_ghost}
\alias{make_ghost}
\title{Make a ghost prey signature}
\usage{
make_ghost(prey_sigs, loc, ghost_err = 0.25, dist_meas = 1, gamma = 1)
}
\arguments{
\item{prey_sigs}{A matrix of prey signatures ready for analysis, intended to
be the object \code{sig_scale} returned by a call to the function
\code{\link{prep_sig}} with the prey data frame or the object
\code{sig_part} returned by \code{\link{make_prey_part}}.}

\item{loc}{A matrix giving the first and last locations of the
signatures of each prey type within \code{prey_sigs}, intended to be the
object \code{loc} returned by a call to the function
\code{\link{prep_sig}} with the prey data frame or the object
\code{loc} returned by \code{\link{make_prey_part}}.}

\item{ghost_err}{A proportion strictly greater than 0 and less than 1 used to
control the lower and upper bounds of ghost prey signature proportions.
Default value 0.25.}

\item{dist_meas}{An integer indicator of the distance measure to be used.
Default value 1.}

\item{gamma}{The power parameter of the chi-square distance measure. Default
value 1.}
}
\value{
A list containing the following elements: \describe{
  \item{sig}{A numeric vector containing the ghost prey signature.}
  \item{dist}{Summed distance between the ghost signature and the mean prey
    signatures.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
}
}
\description{
Bromaghin et al (2016) studied the performance of QFASA estimators when
predators consumed a prey type that was not represented in the prey library,
termed a ghost prey.  \code{make_ghost} constructs a signature for a
ghost prey type.
}
\section{Details}{

One of the major assumptions of QFASA is that the prey library contains
representatives of all prey types consumed by a predator. Bromaghin et al.
(2016) investigated the robustness of diet estimators to violations of this
assumption. The function \code{make_ghost} constructs a ghost prey signature
using the methods of Bromaghin et al. (2016).

The ghost prey signature is constructed by maximizing the summed distance
between the ghost prey signature and the mean prey signatures, while
constraining the ghost signature proportions within reasonable bounds to
ensure that the signature is somewhat realistic for the prey library. The
definition of reasonable bounds is embodied in the argument \code{ghost_err}.
\code{ghost_err} is a proportion greater than or equal to zero and less than 1
that is used to construct lower and upper bounds of the signature
proportions. The lower bound is obtained by multiplying \code{1 - ghost_err}
by the minimum mean prey proportion for each fatty acid. Similarly, the upper
bound is obtained by multiplying \code{1 + ghost_err} by the maximum mean
prey proportion for each fatty acid. The ghost prey signature is then
obtained by maximizing the summed distance between the signature and the mean
prey signatures, constraining the signature to lie within the
bounds and sum to 1. See \code{\link{est_diet}} for information regarding
distance measures.

This method ensures that the ghost prey signature is somewhat distinct from
the other prey types, but not so wildly different that it represents a
completely different pattern from the other prey types. Although research
into suitable values for \code{ghost_err} has not been conducted, it is
probably advisable to use small to moderate values. Bromaghin et al. (2016)
used a value of 0.25. As the value of \code{ghost_err} is increased, the
resulting signature will tend to become increasing different from any prey
type in the library.
}

\section{References}{

Bromaghin, J.F., S.M. Budge, G.W. Thiemann, and K.D. Rode. 2016. Assessing
  the robustness of quantitative fatty acid signature analysis to assumption
  violations. \emph{Methods in Ecology and Evolution} 7:51-59.
}

\examples{
make_ghost(prey_sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                                0.04, 0.11, 0.29, 0.56,
                                0.10, 0.05, 0.35, 0.50,
                                0.12, 0.03, 0.37, 0.48,
                                0.10, 0.06, 0.35, 0.49,
                                0.05, 0.15, 0.35, 0.45), ncol=6),
           loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2),
           ghost_err = 0.15,
           dist_meas = 1,
           gamma = NA)

make_ghost(prey_sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                                0.04, 0.11, 0.29, 0.56,
                                0.10, 0.05, 0.35, 0.50,
                                0.12, 0.03, 0.37, 0.48,
                                0.10, 0.06, 0.35, 0.49,
                                0.05, 0.15, 0.35, 0.45), ncol=6),
           loc = matrix(c(1, 3, 5, 2, 4, 6), ncol=2))

}
