% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_matrix.R
\name{writeBED}
\alias{writeBED}
\title{Write a subset of data from a BED file}
\usage{
writeBED(
  bedRead = NULL,
  bimRead = NULL,
  famRead = NULL,
  bedWrite = NULL,
  bimWrite = NULL,
  famWrite = NULL,
  rsids = NULL,
  endian = .Platform$endian,
  useBytes = TRUE
)
}
\arguments{
\item{bedRead}{The full path to the input BED file to read.}

\item{bimRead}{The full path to the input BIM file to read.}

\item{famRead}{The full path to the input FAM file to read.}

\item{bedWrite}{The full path to the output BED file to write.}

\item{bimWrite}{The full path to the output BIM file to write.}

\item{famWrite}{The full path to the output FAM file to write.}

\item{rsids}{A character vector containing SNP rsids to select from the BIM file.}
}
\value{
No return value. Files are written to the specified output paths.
}
\description{
This function reads a BED file and writes a subset of it based on a list of
SNP (rsids) identifiers to output BED, BIM, and FAM files.
}
\keyword{internal}
