% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_safety.R
\name{market_safety}
\alias{market_safety}
\title{Collects safety z-scores for companies}
\usage{
market_safety(
  companies = qmj::companies_r3k16,
  financials = qmj::financials_r3k16,
  prices = qmj::prices_r3k16
)
}
\arguments{
\item{companies}{A data frame of company names and tickers.}

\item{financials}{A data frame containing financial statements for every 
company.}

\item{prices}{A data frame containing the daily market closing prices and 
returns.}
}
\value{
data.frame of market safety values
}
\description{
Given a data frame of companies (names and tickers), a data frame of financial
statements, and a data frame of daily price data, calculates BAB, IVOL, LEV, 
O, Z, and EVOL, and determines the z-score of overall safety for each company 
based on the paper Quality Minus Junk (Asness et al.) in Appendix page A2.
}
\examples{
\donttest{
# Takes more than 10 secs
market_safety(companies_r3k16[companies_r3k16$ticker \%in\% c("AAPL"), ])
}

}
\seealso{
\code{\link{market_data}}

\code{\link{market_profitability}}

\code{\link{market_growth}}

\code{\link{market_payouts}}
}
