% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{example_db_connect}
\alias{example_db_connect}
\title{Create an example in-memory database}
\usage{
example_db_connect(df = NULL)
}
\arguments{
\item{df}{Optional data.frame to add to the database.}
}
\value{
connection from \code{\link[DBI:dbConnect]{DBI::dbConnect()}}
}
\description{
This function creates a connection to an in-memory SQLite database, with the
option to add a table to the database. This function is intended to facilitate
examples, vignettes, and package tests.
}
\examples{
con <- example_db_connect(mtcars)

x <- DBI::dbGetQuery(con, "SELECT * FROM mtcars;")

head(x)

DBI::dbDisconnect(con)
}
