% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_maps.R
\name{compare_maps}
\alias{compare_maps}
\title{Compare two marker maps}
\usage{
compare_maps(map1, map2)
}
\arguments{
\item{map1}{A list of numeric vectors; each vector gives marker
positions for a single chromosome.}

\item{map2}{A second map, in the same format as \code{map1}.}
}
\value{
A data frame containing
\itemize{
\item \code{marker} - marker name
\item \code{chr_map1} - chromosome ID on \code{map1}
\item \code{pos_map1} - position on \code{map1}
\item \code{chr_map2} - chromosome ID on \code{map2}
\item \code{pos_map2} - position on \code{map2}
}
}
\description{
Compare two marker maps, identifying markers that are only in one
of the two maps, or that are in different orders on the two maps.
}
\examples{
# load some data
iron <- read_cross2( system.file("extdata", "iron.zip", package="qtl2") )
gmap <- iron$gmap
pmap <- iron$pmap

# omit a marker from each map
gmap[[7]] <- gmap[[7]][-3]
pmap[[8]] <- pmap[[8]][-7]
# swap order of a couple of markers on the physical map
names(pmap[[9]])[3:4] <- names(pmap[[9]])[4:3]
# move a marker to a different chromosome
pmap[[10]] <- c(pmap[[10]], pmap[[1]][2])[c(1,3,2)]
pmap[[1]] <- pmap[[1]][-2]

# compare these messed-up maps
compare_maps(gmap, pmap)

}
