% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsmooth_gmap.R
\name{unsmooth_gmap}
\alias{unsmooth_gmap}
\title{Unsmooth genetic map}
\usage{
unsmooth_gmap(gmap, pmap, alpha = 0.02)
}
\arguments{
\item{gmap}{Genetic map, as a list of numeric vectors; each vector gives marker
positions for a single chromosome.}

\item{pmap}{Physical map, as a list of numeric vectors; each vector gives marker
positions for a single chromosome, with the same chromosomes and markers as \code{gmap}.}

\item{alpha}{Proportion of mixture to take from constant recombination.}
}
\value{
A genetic map like the input \code{gmap}, but with the reverse
operation of \code{\link[=smooth_gmap]{smooth_gmap()}} applied, provided that exactly the
same physical map and \code{alpha} are used.
}
\description{
Performs the reverse operation of \code{\link[=smooth_gmap]{smooth_gmap()}}, in case one wants to go back
to the original genetic map.
}
\details{
An interval of genetic length \eqn{d_g}{dg} and physical
length \eqn{d_p}{dp} is changed to have length
\eqn{(d_g - \alpha d_p r)/(1-\alpha)}{(dg + alpha*dp*r)/(1-alpha)}
where \eqn{r = L_g / L_p}{r = Lg/Lp} is the chromosome-specific
recombination rate.
}
\examples{
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))
gmap_adj <- smooth_gmap(iron$gmap, iron$pmap)
gmap_back <- unsmooth_gmap(gmap_adj, iron$pmap)

}
\seealso{
\code{\link[=smooth_gmap]{smooth_gmap()}}
}
\keyword{utilities}
