% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_pxg.R
\name{ggplot_pxg}
\alias{ggplot_pxg}
\alias{mean_pxg}
\title{Plot phenotype vs genotype}
\usage{
ggplot_pxg(
  geno,
  pheno,
  sort = TRUE,
  SEmult = NULL,
  pooledSD = TRUE,
  jitter = 0.2,
  bgcolor = "gray90",
  seg_width = 0.4,
  seg_lwd = 2,
  seg_col = "black",
  hlines = NULL,
  hlines_col = "white",
  hlines_lty = 1,
  hlines_lwd = 1,
  vlines_col = "gray80",
  vlines_lty = 1,
  vlines_lwd = 3,
  force_labels = TRUE,
  alternate_labels = FALSE,
  omit_points = FALSE,
  ...
)

mean_pxg(geno, pheno, dataframe = NULL)
}
\arguments{
\item{geno}{Vector of genotypes, as produced by
\code{\link[qtl2]{maxmarg}} with specific \code{chr} and
\code{pos}.}

\item{pheno}{Vector of phenotypes.}

\item{sort}{If TRUE, sort genotypes from largest to smallest.}

\item{SEmult}{If specified, interval estimates of the within-group
averages will be displayed, as \code{mean +/- SE * SEmult}.}

\item{pooledSD}{If TRUE and \code{SEmult} is specified, calculated
a pooled within-group SD. Otherwise, get separate estimates of
the within-group SD for each group.}

\item{jitter}{Amount to jitter the points horizontally, if a vector
of length > 0, it is taken to be the actual jitter amounts
(with values between -0.5 and 0.5).}

\item{bgcolor}{Background color for the plot.}

\item{seg_width}{Width of segments at the estimated within-group averages}

\item{seg_lwd}{Line width used to plot estimated within-group averages}

\item{seg_col}{Line color used to plot estimated within-group averages}

\item{hlines}{Locations of horizontal grid lines.}

\item{hlines_col}{Color of horizontal grid lines}

\item{hlines_lty}{Line type of horizontal grid lines}

\item{hlines_lwd}{Line width of horizontal grid lines}

\item{vlines_col}{Color of vertical grid lines}

\item{vlines_lty}{Line type of vertical grid lines}

\item{vlines_lwd}{Line width of vertical grid lines}

\item{force_labels}{If TRUE, force all genotype labels to be shown.}

\item{alternate_labels}{If TRUE, place genotype labels in two rows}

\item{omit_points}{If TRUE, omit the points, just plotting the averages (and, potentially, the +/- SE intervals).}

\item{...}{Additional graphics parameters, passed to \code{\link[graphics]{plot}}.}

\item{dataframe}{Supplied data frame, or constructed from \code{geno} and \code{pheno} if \code{NULL}.}
}
\value{
object of class \code{\link[ggplot2]{ggplot}}.
}
\description{
Plot phenotype vs genotype for a single putative QTL and a single phenotype.
}
\examples{
# load qtl2 package for data and genoprob calculation
library(qtl2)

# read data
iron <- read_cross2(system.file("extdata", "iron.zip", package="qtl2"))

# insert pseudomarkers into map
map <- insert_pseudomarkers(iron$gmap, step=1)

# calculate genotype probabilities
probs <- calc_genoprob(iron, map, error_prob=0.002)

# inferred genotype at a 28.6 cM on chr 16
geno <- maxmarg(probs, map, chr=16, pos=28.6, return_char=TRUE)

# plot phenotype vs genotype
ggplot_pxg(geno, log10(iron$pheno[,1]), ylab=expression(log[10](Liver)))

# include +/- 2 SE intervals
ggplot_pxg(geno, log10(iron$pheno[,1]), ylab=expression(log[10](Liver)),
         SEmult=2)

# plot just the means
ggplot_pxg(geno, log10(iron$pheno[,1]), ylab=expression(log[10](Liver)),
         omit_points=TRUE)

# plot just the means +/- 2 SEs
ggplot_pxg(geno, log10(iron$pheno[,1]), ylab=expression(log[10](Liver)),
         omit_points=TRUE, SEmult=2)
}
\seealso{
\code{\link[qtl2]{plot_coef}}
}
