% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_coords.R
\name{get_qk_coord}
\alias{get_qk_coord}
\title{Get lat/long coordinates from the QuadKey}
\usage{
get_qk_coord(data)
}
\arguments{
\item{data}{A dataframe with a quadkey column.}
}
\value{
A \code{sf} POINT data.frame containing the tiles XY coordinates
(\code{tileX}, \code{tileY}), the QuadKeys (\code{quadkey}), and a \code{geometry} column.
}
\description{
Reads the QuadKey as a string and extracts the
lat/long coordinates of the upper-left corner of the QuadKey.
}
\examples{

grid <- create_qk_grid(
  xmin = -59,
  xmax = -40,
  ymin = -38,
  ymax = -20,
  zoom = 6
)

# quadkey column in grid$data converted to geographic coordinates
grid_coords <- get_qk_coord(data = grid$data)

plot(grid_coords)
}
\seealso{
\code{\link{quadkey_to_tileXY}}

\code{\link{tileXY_to_pixelXY}}

\code{\link{pixelXY_to_latlong}}
}
