% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qk_to_latlong_functions.R
\name{quadkey_to_latlong}
\alias{quadkey_to_latlong}
\title{Convert a string of Quadkey numbers to lat/long coordinates}
\usage{
quadkey_to_latlong(quadkey_data)
}
\arguments{
\item{quadkey_data}{A single QuadKey as a string or
a vector with unique QuadKeys.}
}
\value{
A sf POINT data.frame with a \code{quadkey} column.
The latitude/longitude coordinates represent
the upper-left corner of the QuadKey.
}
\description{
This function converts Quadkeys to
latitude/longitude WGS-84 coordinates (in degrees).
For further information, refer to the Microsoft Bing Maps Tile System
documentation.
}
\details{
Converting latitude/longitude coordinates into a QuadKey
and then back to latitude/longitude won't yield identical values,
unless the initial latitude/longitude coordinates
correspond to the upper-left Quadkey's pixel and tile XY coordinates
at the same zoom level.

Understanding this distinction is crucial for
the accurate use of these functions in coordinate conversions.

For a detailed explanation on how to use this
and other similar \code{quadkeyr} functions,
read the the vignette:
\url{https://docs.ropensci.org/quadkeyr/articles/quadkey_to_sf_conversion.html}
}
\examples{

quadkey_to_latlong(quadkey_data = "213")
quadkey_to_latlong(quadkey_data = c("213", "212", "210"))

}
\references{
\url{https://learn.microsoft.com/en-us/bingmaps/articles/bing-maps-tile-system}
}
\seealso{
\code{\link{quadkey_to_tileXY}}

\code{\link{tileXY_to_pixelXY}}

\code{\link{pixelXY_to_latlong}}
}
