% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tri_grid.R
\name{bary_index}
\alias{bary_index}
\title{Barycentric triangle index for interpolation}
\usage{
bary_index(x, coords = NULL, grid = NULL, ...)
}
\arguments{
\item{x}{a 'RasterLayer' source}

\item{coords}{optional input coordinates}

\item{grid}{target 'RasterLayer', a target regular grid}

\item{...}{ignored}
}
\value{
RasterLayer
}
\description{
This function returns the barycentric weight for a grid of coordinates
from a geographic raster.
}
\details{
It's not as fast as \code{\link[raster:projectRaster]{raster::projectRaster()}} (e.g. \code{projectRaster(x, grid)}) but it
also accepts a \code{coords} argument and so can be used for non-regular raster
reprojection.

'coords' may be 'NULL' or longitude, latitude in a 2-layer raster brick or stack as with
\code{mesh_plot}.
}
\examples{
library(raster)
p_srs <- "+proj=stere +lat_0=-90 +lat_ts=-71 +datum=WGS84"
polar <- raster(extent(-5e6, 5e6, -5e6, 5e6), crs = p_srs, res = 25000)
etopo <- aggregate(etopo, fact = 4)
index <- bary_index(etopo, grid = polar)
ok <- !is.na(index$idx)
r <- setValues(polar, NA_integer_)
r[ok] <- colSums(matrix(values(etopo)[index$tri[, index$idx[ok]]], nrow = 3) * t(index$p)[, ok])
plot(r)
}
