% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locNormCst.R
\name{locNormCst}
\alias{locNormCst}
\title{Normal local constant estimator}
\usage{
locNormCst(
  x,
  y,
  bandwidth.method = "CV",
  kernel = locpol::gaussK,
  cents = c(0.03, 0.25, 0.5, 0.75, 0.97),
  disp_window = TRUE,
  leg = FALSE,
  axes.lab = NULL
)
}
\arguments{
\item{x}{the explanatory variable - numeric}

\item{y}{the response variable - numeric}

\item{bandwidth.method}{the bandwidth method choice: CV or plug-in. Default is CV.}

\item{kernel}{Kernel used to perform the estimation, see Kernels (from locpol).}

\item{cents}{A numeric vector that represents the centiles calculated. Default is set to cents=c(0.03,0.25,0.5,0.75,0.97)).}

\item{disp_window}{Boolean. Should the scale of bandwidth be displayed (TRUE) or not (FALSE).}

\item{leg}{Boolean. Should the legend be desplayed (TRUE) or not (FALSE).}

\item{axes.lab}{NULL or c("Nom_axe_X, Nom_axe_Y").}
}
\value{
Plots the centile curves and returns a list object containing bandwidth value and estimated centiles values.
}
\description{
Normal local constant estimator
}
\examples{
#create an example data frame
weights=c(500,600,1000,1150,1200,1260,1240,1300,1370,1500,2000,2100,2150,2500,
2800,2900,3050,3200,2980,3000,3300,3100,3200,3600,3500,3700,3900,3900,4000,
4200,3000,4500,4300,4900,4350,3700,4000,5000,4300)
age<-c(30,30,30,31,31,31,32,32,32,33,33,33,34,34,34,35,35,35,36,36,36,
37,37,37,38,38,38,39,39,39,40,40,40,41,41,41,42,42,42)
sample<-data.frame(age,weights)
colnames(sample)<-c("Gestational Age in weeks","Weight in gramms")
x<-sample$`Gestational Age in weeks`
y<-sample$`Weight in gramms`
#calculate the centile and plot the curves
locNormCst(x,y, kernel=locpol::gaussK)
}
