% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_query.R
\name{split_query}
\alias{split_query}
\title{Split a SQL query}
\usage{
split_query(query, tidyverse)
}
\arguments{
\item{query}{a character string containing a SQL \code{SELECT} statement}

\item{tidyverse}{for queryparser internal use only}
}
\value{
A list object with named elements representing the clauses of the
  query
}
\description{
Splits a SQL \code{SELECT} statement into clauses, and splits
  comma-separated column lists within the clauses.
}
\examples{
my_query <- "SELECT origin, dest,
    COUNT(flight) AS num_flts,
    round(AVG(distance)) AS dist,
    round(AVG(arr_delay)) AS avg_delay
  FROM flights
  WHERE distance BETWEEN 200 AND 300
    AND air_time IS NOT NULL
  GROUP BY origin, dest
  HAVING num_flts > 3000
  ORDER BY num_flts DESC, avg_delay DESC
  LIMIT 100;"

split_query(my_query)
}
\seealso{
\code{\link{parse_query}}
}
