% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{vecNA}
\alias{vecNA}
\title{Frequency of Missing Values in a Vector}
\usage{
vecNA(x, prop = FALSE, ov = FALSE)
}
\arguments{
\item{x}{atomic vector or list vector. If not a vector, it will be coerced to
a vector via \code{\link{as.vector}}.}

\item{prop}{logical vector of length 1 specifying whether the frequency of
missing values should be returned as a proportion (TRUE) or a count
(FALSE).}

\item{ov}{logical vector of length 1 specifying whether the frequency of
observed values (TRUE) should be returned rather than the frequency of
missing values (FALSE).}
}
\value{
numeric vector of length 1 providing the frequency of missing values
  (or observed values if \code{ov} = TRUE). If \code{prop} = TRUE, the value
  will range from 0 to 1. If \code{prop} = FALSE, the value will range from 1
  to \code{length(x)}.
}
\description{
\code{vecNA} computes the frequency of missing values in an atomic vector.
\code{vecNA} is essentially a wrapper for \code{sum} or \code{mean} +
\code{is.na} or \code{!is.na} and can be useful for functional programming
(e.g., \code{lapply(FUN = vecNA)}). It is also used by other functions in the
quest package related to missing values (e.g., \code{\link{mean_if}}).
}
\examples{
vecNA(airquality[[1]]) # count of missing values
vecNA(airquality[[1]], prop = TRUE) # proportion of missing values
vecNA(airquality[[1]], ov = TRUE) # count of observed values
vecNA(airquality[[1]], prop = TRUE, ov = TRUE) # proportion of observed values
}
\seealso{
\code{\link{is.na}}
   \code{\link{rowNA}}
   \code{\link{colNA}}
   \code{\link{rowsNA}}
}
