% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{deffs}
\alias{deffs}
\title{Design Effects from Multilevel Numeric Data}
\usage{
deffs(data, vrb.nm, grp.nm, how = "lme", REML = FALSE)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variable columns.}

\item{grp.nm}{character vector of length 1 of a colname from \code{data}
specifying the grouping column.}

\item{how}{character vector of length 1 specifying how the ICC(1,1) should be
calculated. There are four options: 1) "lme" uses a linear mixed effects
model with the function \code{\link[nlme]{lme}} from the package
\code{nlme}, 2) "lmer" uses a linear mixed effects modeling with the
function \code{\link[lme4]{lmer}} from the package \code{lme4}, 3) "aov"
uses a one-way analysis of variance with the function
\code{\link[stats]{aov}}, and 4) "raw" uses the observed variances, which
provides a biased estimate of the ICC(1,1) and is not recommended (It is
only included for teaching purposes).}

\item{REML}{logical vector of length 1 specifying whether restricted maximum
likelihood estimation (TRUE) should be used rather than traditional maximum
likelihood estimation (FALSE). Only used for linear mixed effects models if
how = "lme" or how = "lmer".}
}
\value{
double vector providing the design effects with names =
  \code{vrb.nm}.
}
\description{
\code{deffs} computes the design effects for multilevel numeric data. Design
effects summarize how much larger sampling variances (i.e., squared standard
errors) are due to the multilevel structure of the data. By taking the square
root, the value summarizes how much larger standard errors are due to the
multilevel structure of the data.
}
\details{
Design effects are a function of both the intraclass correlation (ICC) and
the average group size. Design effects can be large due to large ICCs and
small group sizes or small ICCs and large group sizes. For example, with an
ICC = .01 and average group size of 100, the design effect would be 2.0,
whose square root is 1.41. For more information, see myths 1 and 2 in
Huang (2018).
}
\examples{

iccs_11(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month")
lengths_by(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month", na.rm = TRUE)
deffs(data = airquality, vrb.nm = c("Ozone","Solar.R"), grp.nm = "Month")

}
\references{
Huang, F. L. (2018). Multilevel modeling myths School Psychology Quarterly,
33(3), 492-499.
}
\seealso{
\code{\link{iccs_11}}
   \code{\link{deff}}
}
