% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-helpers.R
\name{coordinates}
\alias{coordinates}
\alias{coordinates,ANY-method}
\title{Extract coordinates from a variety of spatial objects}
\usage{
\S4method{coordinates}{ANY}(obj, ...)
}
\arguments{
\item{obj}{An object from which to extract the coordinates (e.g., \code{sf}, \code{sp})}

\item{...}{Ignored.}
}
\value{
A 2 column matrix of coordinates (x and y)
}
\description{
This will extract using \code{terra::crds}, \code{sf::st_coordinates} and
\code{raster::coordinates}. Other packages can create methods, as this is
generic.
}
\examples{
library(terra)
caribou <- terra::vect(
  x = cbind(
    x = stats::runif(1e1, -50, 50),
    y = stats::runif(1e1, -50, 50)
  )
)
coordinates(caribou)

}
