% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{calc_bins_y}
\alias{calc_bins_y}
\title{Calculate the effective number of bins along x-axis and y-axis}
\usage{
calc_bins_y(nldr_scaled_obj, b1 = 30, q = 0.1)
}
\arguments{
\item{nldr_scaled_obj}{A list of a tibble contains scaled first and second columns
of NLDR data, and numeric vectors representing the limits of the original NLDR data.}

\item{b1}{Number of bins along the x axis.}

\item{q}{The buffer amount as proportion of data range.}
}
\value{
A list of numeric values that represents the effective number of
bins along the y axis, height and, width of the hexagon.
}
\description{
This function calculates the effective number of bins along the x and y axes
of a hexagonal grid.
}
\examples{
calc_bins_y(nldr_scaled_obj = scurve_model_obj$nldr_scaled_obj, b1 = 30, q = 0.1)

}
