% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{act_eigfun.spectral}
\alias{act_eigfun.spectral}
\title{Apply a Function to a Hermitian Matrix}
\usage{
\method{act_eigfun}{spectral}(object, FUN, ...)
}
\arguments{
\item{object}{an instance of class \code{spectral}.}

\item{FUN}{the function to be applied to the matrix.}

\item{...}{further arguments passed on to \code{FUN}.}
}
\value{
The matrix resulting from the application of \code{FUN}.

A Hermitian Matrix admits the spectral decomposition
\deqn{H = \sum_k \lambda_k E_k}
where \eqn{\lambda_k} are its eigenvalues and \eqn{E_k} the
orthogonal projector onto the \eqn{\lambda_k}-eigenspace.

If \eqn{f}=\code{FUN} is defined on the eigenvalues of \code{H}, then
\code{act_eigfun} performs the following calculation

\deqn{f(H) = \sum_k f(\lambda_k) E_k}
}
\description{
Apply a function to a Hermitian matrix based on the representation
given by class \code{spectral}.
}
\examples{
H <- matrix(c(0,1,1,1,0,1,1,1,0), nrow=3)
decomp <- spectral(H)

# Calculates H^2.
act_eigfun(decomp, FUN = function(x) x^2)

# Calculates sin(H).
act_eigfun(decomp, FUN = function(x) sin(x))

# Calculates H^3.
act_eigfun(decomp, FUN = function(x, y) x^y, 3)

}
\seealso{
\code{\link[=spectral]{spectral()}}, \code{\link[=act_eigfun]{act_eigfun()}}
}
