% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qplot_trajectory.R
\name{qplot_trajectory}
\alias{qplot_trajectory}
\title{Create a quick trajectory plot}
\usage{
qplot_trajectory(data)
}
\arguments{
\item{data}{A data frame like the outputs of \code{prep_trajectory()}.
\itemize{
\item (Optional) If present, the column \code{label} is used for data labels.
}}
}
\value{
An object of class "ggplot".
}
\description{
Compared to \code{\link[=plot_trajectory]{plot_trajectory()}} this function:
\itemize{
\item is restricted to plotting only 5 years from the start year,
\item outputs pretty legend labels, based on the column holding metrics,
\item outputs a title,
\item outputs a subtitle,
\item outputs informative axis labels in sentence case.
}
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(
  market_share_demo,
  sector == "power" &
    technology == "renewablescap" &
    region == "global" &
    scenario_source == "demo_2020"
)

qplot_trajectory(data)
}
\seealso{
plot_trajectory
}
