% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_r2dii_sector.R
\name{scale_colour_r2dii_sector}
\alias{scale_colour_r2dii_sector}
\alias{scale_color_r2dii_sector}
\alias{scale_fill_r2dii_sector}
\title{Custom PACTA sector colour and fill scales}
\usage{
scale_colour_r2dii_sector(sectors = NULL, ...)

scale_fill_r2dii_sector(sectors = NULL, ...)
}
\arguments{
\item{sectors}{A character vector. Specifies sector colours to use and their
order. Run \code{unique(r2dii.plot:::sector_colours$label)} to see available
labels. Similar to \code{value} parameter in \code{\link[ggplot2:scale_manual]{ggplot2::scale_colour_manual()}}.}

\item{...}{Other parameters passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\value{
An object of class "ScaleDiscrete".
}
\description{
A custom discrete colour and fill scales with colours from the PACTA sector
palette.
}
\examples{
library(ggplot2, warn.conflicts = FALSE)

ggplot(mpg) +
  geom_point(aes(displ, hwy, color = class)) +
  scale_colour_r2dii_sector()

ggplot(mpg) +
  geom_histogram(aes(cyl, fill = class), position = "dodge", bins = 5) +
  scale_fill_r2dii_sector()
}
\seealso{
Other r2dii scales: 
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_tech}()}
}
\concept{r2dii scales}
