#' Crystal structure of the SARS-CoV-2 helicase at 1.94 Angstrom resolution in
#' PDB format
#'
#' @source DOI: 10.2210/pdb6ZSL/pdb. \url{https://www.rcsb.org/structure/6zsl}
#'
#' @format PDB Format.
"pdb_6zsl"

#' Crystal Structure of Mutant Macrophage Capping Protein (Cap G) with
#' Actin-severing Activity in the Ca2+-Free Form in PDB format
#'
#' @source DOI: 10.2210/pdb1J72/pdb. \url{https://www.rcsb.org/structure/1J72}
#'
#' @format PDB Format.
"pdb_1j72"

# nolint start
#' Gaussian cube file example
#'
#' @source <https://github.com/3dmol/3Dmol.js/blob/master/tests/test_structs/benzene-homo.cube>
#'
#' @format Gaussian cube format
# nolint end
"cube_benzene_homo"

# nolint start
#' Multiple sdf file example
#'
#' @source <https://github.com/3dmol/3Dmol.js/blob/master/tests/test_structs/multiple.sdf>
#'
#' @format sdf format
# nolint end
"sdf_multiple"

# nolint start
#' Multiple xyz file example
#'
#' @source <https://github.com/3dmol/3Dmol.js/blob/master/tests/test_structs/multiple2.xyz>
#'
#' @format xyz format
# nolint end
"xyz_multiple"

# nolint start
#' Cif file example
#'
#' @source <https://github.com/3dmol/3Dmol.js/blob/master/tests/auto/data/254385.cif>
#'
#' @format cif format
# nolint end
"cif_254385"
