% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimpse.R
\name{m_glimpse}
\alias{m_glimpse}
\title{Quickly View Given Structure}
\usage{
m_glimpse(
  model,
  highlight = m_sel(),
  zoom = TRUE,
  spin = FALSE,
  nomouse = FALSE,
  ribbon = FALSE,
  outline = TRUE,
  backgroundColor = "white"
)
}
\arguments{
\item{model}{Model to add to scene. Can be \code{{bio3d}} pdb object or PDB
id code string (i.e "4ozs").}

\item{highlight}{Given selection will additionally have 'ball-n-stick'
representation. View will also zoom to selection.}

\item{zoom}{Logical. FALSE will not zoom onto highlighted selection.}

\item{spin}{TRUE / FALSE will enable or disable spin. A numeric value will
change spin speed and negative will reverse the direction.}

\item{nomouse}{Logical. Enables / disables mouse input.}

\item{ribbon}{Logical. Enables / disables ribbon representation.}

\item{outline}{Logical. Enables / disables black outline.}

\item{backgroundColor}{String of simple colour names or hex code to change
background color of viewer.}
}
\description{
Creates a scene with a number of simple defaults in order to quickly view
the structure without having to write multiple lines of code.
}
\examples{
library(r3dmol)

# write/read demo structure as {bio3d} object
tmp <- tempfile()
write(pdb_6zsl, tmp)
pdb <- bio3d::read.pdb(tmp)

# quickly preview structure
pdb \%>\%
  m_glimpse()

# preview structure, highlighting particular region.
pdb \%>\%
  m_glimpse(m_sel(resi = 1:10, chain = "A"), spin = 0.2)
\dontrun{

# Fetch given PDB string and quickly preview structure
"4ozs" \%>\%
  m_glimpse(spin = TRUE)
}
}
