% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{congestion_poly2geojson}
\alias{congestion_poly2geojson}
\title{Save speeds polygon to .geojson temporary file}
\usage{
congestion_poly2geojson(new_speeds_poly)
}
\arguments{
\item{new_speeds_poly}{An sf polygon}
}
\value{
The path to a \code{.geojson} saved as a temporary file.
}
\description{
Support function that checks the input of speeds polygon passed to
\code{build_custom_network()} and saves it to a \code{.geojson} temporary file.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# read polygons with new speeds
congestion_poly <- readRDS(
  system.file("extdata/poa/poa_poly_congestion.rds", package = "r5r")
  )

geojson_path <- r5r:::congestion_poly2geojson(
  new_speeds_poly = congestion_poly
  )
\dontshow{\}) # examplesIf}
}
\seealso{
Other Support functions: 
\code{\link{lts_lines2shp}()}
}
\concept{Support functions}
\keyword{internal}
