% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r5r_cache.R
\name{r5r_cache}
\alias{r5r_cache}
\title{Manage cached files from the r5r package}
\usage{
r5r_cache(list_files = TRUE, delete_file = NULL)
}
\arguments{
\item{list_files}{Logical. Whether to print a message with the address of r5r
JAR files cached locally. Defaults to \code{TRUE}.}

\item{delete_file}{String. The file name (basename) of a JAR file cached
locally that should be deleted. Defaults to \code{NULL}, so that no
file is deleted. If \code{delete_file = "all"}, then all cached files are
deleted.}
}
\value{
A message indicating which file exist and/or which ones have been
deleted from local cache directory.
}
\description{
Manage cached files from the r5r package
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# download r5 JAR
r5r::download_r5()

# list all files cached
r5r_cache(list_files = TRUE)

# delete r5 JAR
r5r_cache(delete_file = 'r5-v7.0')
\dontshow{\}) # examplesIf}
}
\concept{Cache data}
