% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{acme_model}
\alias{acme_model}
\title{Model the Data}
\usage{
acme_model(
  data,
  columns,
  n_chains = 1,
  n_adapt_steps = 500,
  n_burn = 1000,
  n_thin = 1,
  n_steps = 10000,
  seed = 42,
  stan = FALSE
)
}
\arguments{
\item{data}{data.frame The data to format}

\item{columns}{vector The columns to target}

\item{n_chains}{numeric Number of chains to run, default = 1}

\item{n_adapt_steps}{numeric Number of adapt steps to run, default = 500}

\item{n_burn}{numeric Number of draws to burn at the start, default = 1000}

\item{n_thin}{numeric Thinning factor for the draws, default = 1}

\item{n_steps}{numeric The total number of draws to run, default = 10,000}

\item{seed}{numeric The random seed to set}

\item{stan}{boolean If you would like to use the experimental Stan backend}
}
\value{
List with all the appropriate things needed
for modelling with JAGS
}
\description{
Using the methodology generated by Muoko et. al (see README for
full citation), run the modelling with the JAGS sampler. This
function accepts a number of different arguments, but defaulted
arguments are assumed to be best for \emph{most} systems. Obviously,
if there is prior knowledge, this can be adjusted at the user's
own discretion.
}
\examples{
data <- data.frame(list("fruit" = c(1, 2), "veg" = c(3, 4)))
acme_model(data, names(data))
}
