% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_PeriodSelector.R
\name{initialize,PeriodSelector-method}
\alias{initialize,PeriodSelector-method}
\alias{periodSelector}
\alias{addPeriod}
\alias{addPeriod,PeriodSelector-method}
\title{Initializes a PeriodSelector}
\usage{
\S4method{initialize}{PeriodSelector}(.Object, periods, ...)

periodSelector(periods, ...)

addPeriod(.Object, ...)

\S4method{addPeriod}{PeriodSelector}(.Object, ...)
}
\arguments{
\item{.Object}{\linkS4class{PeriodSelector}.}

\item{periods}{\code{list}.
Period object has 4 properties - period, count, label and selected.
Possible period values are:
"ss" - seconds, "mm" - minutes, "hh" - hours, "DD" - days, "MM" - months and "YYYY" - years.
property "count" specifies how many periods this button will select.
"label" will be displayed on a button and "selected" is a logical.
which specifies if this button is selected when chart is initialized or not.}

\item{...}{other properties of PeriodSelector.}
}
\value{
(updated) .Object of class \linkS4class{PeriodSelector}.
}
\description{
Uses the constructors to create the object with its properties
or update an existing one with the setters.
}
\examples{
new( "PeriodSelector")
periodSelector(fillAlpha = .4, value = 1)
periodSelector(fillAlpha = .4, adjustBorderColor = TRUE, gridThickness = 1)
addPeriod(.Object = periodSelector(), period = "MM", selected = TRUE,
          count = 1, label= "1 month")
}
