% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qedata_define.R
\name{metadata}
\alias{metadata}
\title{Reclassify specified columns as metadata or list metadata columns in a data.table}
\usage{
metadata(x, ...)
}
\arguments{
\item{x}{A data.table. The data.table containing the columns to be reclassified or checked.}

\item{...}{Additional arguments specifying the names of the columns to be reclassified.}
}
\value{
The modified data.table with specified columns reclassified as 'qe.metadata', or a character vector of column names already classified as 'qe.metadata'.
}
\description{
This function reclassifies specified columns of a data.table to the 'qe.metadata' format if column names are provided.
If no column names are provided, it returns the names of columns that are already classified as 'qe.metadata'.
}
\examples{
library(data.table)
dt <- data.table(a = 1:5, b = 6:10)
# Reclassify columns 'a' and 'b' as 'qe.metadata'
dt <- metadata(dt, "a", "b")
# List columns classified as 'qe.metadata'
metadata_columns <- metadata(dt)
}
