% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rGroovy.R
\name{Execute}
\alias{Execute}
\title{Function executes the groovy script and returns the result. Execute differs from Evaluate in that references to
Groovy objects are not required. The call to Initialize is not required in order to call this function either however
keep in mind that a new instance of \href{http://docs.groovy-lang.org/latest/html/api/groovy/lang/GroovyShell.html}{groovy.lang.GroovyShell}
will be used every time this function is called.}
\usage{
Execute(groovyScript, variables = list())
}
\arguments{
\item{groovyScript}{The groovy script being executed.}

\item{variables}{The variables that will be passed to the binding that is used when the groovyScript is executed.}
}
\description{
Function executes the groovy script and returns the result. Execute differs from Evaluate in that references to
Groovy objects are not required. The call to Initialize is not required in order to call this function either however
keep in mind that a new instance of \href{http://docs.groovy-lang.org/latest/html/api/groovy/lang/GroovyShell.html}{groovy.lang.GroovyShell}
will be used every time this function is called.
}
\examples{
 \dontrun{
 variables <- list ()

 variables["name"] = "Tom"
 variables["day"]  = "Wednesday"

 groovyScript <- "return \\"Hello ${name}, how are you doing? Today is ${day}.\\""

 result <- Execute (groovyScript=groovyScript, variables=variables)
 result
 }

}
